/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.record.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.IpSetting;
import com.tp_link.eap.domain.eap.bean.LoadBalance;
import com.tp_link.eap.domain.eap.bean.Radio;
import com.tp_link.eap.domain.eap.bean.RssiThreshold;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.eap.bean.TrunkSetting;
import com.tp_link.eap.domain.eapsetting.CommonCloneable;
import com.tp_link.eap.domain.eapsetting.MacFilterAssocConfig;
import com.tp_link.eap.domain.eapsetting.MacFilterAssocRule;
import com.tp_link.eap.domain.eapsetting.MacFilterConfig;
import com.tp_link.eap.domain.eapsetting.MacFilterRule;
import com.tp_link.eap.domain.eapsetting.PortalFreePolicy;
import com.tp_link.eap.domain.eapsetting.PortalFreePolicyConfig;
import com.tp_link.eap.domain.eapsetting.SchedulerAssocAp;
import com.tp_link.eap.domain.eapsetting.SchedulerAssocApRule;
import com.tp_link.eap.domain.eapsetting.SchedulerAssocConfig;
import com.tp_link.eap.domain.eapsetting.SchedulerAssocRule;
import com.tp_link.eap.domain.eapsetting.SchedulerConfig;
import com.tp_link.eap.domain.eapsetting.SchedulerRule;
import com.tp_link.eap.domain.eapsetting.SsidC;
import com.tp_link.eap.domain.eapsetting.SsidConfig;
import com.tp_link.eap.domain.eapsetting.SsidRateLimit;
import com.tp_link.eap.domain.eapsetting.URLPortalFreePolicy;
import com.tp_link.eap.domain.eapsetting.UserAccountConfig;
import com.tp_link.eap.domain.eapstats.DeviceMisc;
import com.tp_link.eap.domain.globalsetting.Profile;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.StationMacList;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.mesh.pojo.ConfigChildAP;
import com.tp_link.eap.domain.mesh.pojo.Mesh;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.record.SettingRecord;
import com.tp_link.eap.domain.roaming.document.ApNeighborList;
import com.tp_link.eap.domain.roaming.json.IssuedRoamingInfo;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.monitor.globalsetting.a.c;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.globalsetting.service.j;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.globalsetting.service.m;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.i;
import com.tp_link.eap.monitor.record.repo.RecordRepository;
import com.tp_link.eap.monitor.record.service.b;
import com.tp_link.eap.monitor.record.service.impl.a;
import com.tp_link.eap.util.a.e;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="recordService")
public class RecordService
implements com.tp_link.eap.monitor.record.service.a {
    @Autowired
    private RecordRepository c;
    @Autowired
    private g d;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b e;
    @Autowired
    private i f;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.e g;
    @Autowired
    private b h;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d i;
    @Autowired
    private l j;
    @Autowired
    private m k;
    @Autowired
    private j l;
    @Autowired
    private d m;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.a n;
    @Autowired
    private MongoTemplate o;
    private ExecutorService p = Executors.newSingleThreadExecutor();
    Logger a = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<SettingRecord> getPendingRecords() {
        ArrayList<SettingRecord> arrayList = new ArrayList<SettingRecord>();
        arrayList.addAll(this.c.getByFilters(null, null, Collections.singletonList(new QueryFilter("status", (Object)SettingRecord.SettingStatus.PENDING, QueryFilter.FilterType.eq)), null));
        return arrayList;
    }

    @Override
    public SettingRecord refreshRecord(SettingRecord sr) {
        if (sr == null || sr.getApMac() == null) {
            throw new IllegalArgumentException("Setting Record to refresh is null.");
        }
        String string = sr.getApMac();
        this.h.refreshVersion(string);
        if (!com.tp_link.eap.monitor.monitor.realtime.c.i(string)) {
            this.a.debug("not compatible with controller, should not send config for mac : " + string);
            return null;
        }
        this.a.debug("refresh record for mac : " + string);
        com.tp_link.eap.monitor.record.a.a.b(string);
        SettingRecord settingRecord = this.c.findByApMacAndStatus(string, SettingRecord.SettingStatus.PENDING);
        if (settingRecord != null) {
            settingRecord.setContent(sr.getContent());
            return (SettingRecord)this.c.save(settingRecord);
        }
        SettingRecord settingRecord2 = this.c.findByApMacAndStatus(string, SettingRecord.SettingStatus.SENDING);
        settingRecord = this.c.findByApMacAndStatus(string, SettingRecord.SettingStatus.BACKUP);
        if (settingRecord != null) {
            settingRecord.setContent(sr.getContent());
            return (SettingRecord)this.c.save(settingRecord);
        }
        if (settingRecord2 != null) {
            sr.setStatus(SettingRecord.SettingStatus.BACKUP);
        } else {
            sr.setStatus(SettingRecord.SettingStatus.PENDING);
        }
        return (SettingRecord)this.c.save(sr);
    }

    @Override
    public void deleteRecord(String apMac, boolean deleteAll) {
        if (com.tp_link.eap.util.a.e.a((String)apMac)) {
            return;
        }
        com.tp_link.eap.monitor.record.a.a.a(apMac);
        if (deleteAll) {
            List<SettingRecord> list = this.c.findByApMac(apMac);
            if (list != null) {
                this.c.delete(list);
            }
        } else {
            SettingRecord settingRecord = this.c.findByApMacAndStatus(apMac, SettingRecord.SettingStatus.SENDING);
            if (settingRecord != null) {
                this.c.delete(settingRecord);
            }
            if ((settingRecord = this.c.findByApMacAndStatus(apMac, SettingRecord.SettingStatus.BACKUP)) != null) {
                settingRecord.setStatus(SettingRecord.SettingStatus.PENDING);
                this.c.save(settingRecord);
                this.a.debug("still has config to send for mac : " + apMac);
                if (com.tp_link.eap.monitor.monitor.realtime.c.i(apMac)) {
                    com.tp_link.eap.monitor.record.a.a.b(apMac);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRecord(String apMac, String settingTarget, Object settingContent) {
        MacFilterAssocRule macFilterAssocRule;
        SettingRecord settingRecord;
        Object object;
        Object object2;
        Ap ap;
        boolean bl = false;
        boolean bl2 = false;
        if (settingTarget.equals("lanSettingIpChange")) {
            bl2 = true;
            settingTarget = "lanSetting";
        }
        if ((ap = this.e.getApDetail(apMac)) == null) {
            return;
        }
        if (!com.tp_link.eap.util.e.a((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) {
            if (settingTarget.endsWith("5G")) {
                return;
            }
            if (settingTarget.equals("macFilterAssoc")) {
                object2 = (MacFilterAssocConfig)settingContent;
                object = object2.getRule();
                settingRecord = object.iterator();
                while (settingRecord.hasNext()) {
                    macFilterAssocRule = (MacFilterAssocRule)settingRecord.next();
                    if (macFilterAssocRule.getBand() != 1) continue;
                    return;
                }
            }
            if (settingTarget.equals("schedulerAssoc")) {
                object2 = (SchedulerAssocConfig)settingContent;
                object = object2.getRule();
                settingRecord = object.iterator();
                while (settingRecord.hasNext()) {
                    macFilterAssocRule = (SchedulerAssocRule)settingRecord.next();
                    if (macFilterAssocRule.getBand() != 1) continue;
                    return;
                }
            }
        }
        com.tp_link.eap.d.b.f((String)apMac);
        object = object2 = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object) {
            Object object3;
            Object object4;
            if (!com.tp_link.eap.monitor.monitor.realtime.c.i(apMac)) {
                this.a.debug("not compatible with controller, should not send config for mac : " + apMac);
                return;
            }
            this.a.debug("refresh record for mac : " + apMac);
            com.tp_link.eap.monitor.record.a.a.b(apMac);
            settingRecord = this.c.findByApMacAndStatus(apMac, SettingRecord.SettingStatus.SENDING);
            if (settingRecord != null) {
                bl = true;
            }
            macFilterAssocRule = this.c.findByApMacAndStatus(apMac, bl ? SettingRecord.SettingStatus.BACKUP : SettingRecord.SettingStatus.PENDING);
            Map<Object, Object> map = new HashMap<String, Object>();
            if (!this.a(settingTarget)) {
                if (macFilterAssocRule == null) {
                    map.put(settingTarget, settingContent);
                } else {
                    map = com.tp_link.eap.util.a.b.a((String)macFilterAssocRule.getContent());
                    if (map == null) {
                        map = new HashMap();
                    }
                    if (settingTarget.equals("userAccount")) {
                        object4 = map.get(settingTarget);
                        if (object4 != null) {
                            object3 = (HashMap)object4;
                            Object v = ((HashMap)object3).get("curPassword");
                            Object v2 = ((HashMap)object3).get("curUsername");
                            UserAccountConfig userAccountConfig = (UserAccountConfig)settingContent;
                            userAccountConfig.setCurPassword((String)v);
                            userAccountConfig.setCurUsername((String)v2);
                            map.put(settingTarget, userAccountConfig);
                        } else {
                            map.put(settingTarget, settingContent);
                        }
                    } else {
                        map.put(settingTarget, settingContent);
                    }
                    macFilterAssocRule.setContent(com.tp_link.eap.util.a.b.a(map));
                }
            } else {
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Object object10;
                map = this.a(apMac, (SettingRecord)macFilterAssocRule, settingTarget, settingContent);
                if (settingTarget.equals("roaming")) {
                    object4 = this.a(map.get(settingTarget), settingContent);
                    map.put(settingTarget, object4);
                }
                if (settingTarget.equals("ssid_2G") || settingTarget.equals("ssid_5G")) {
                    object4 = (SsidConfig)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)settingContent), SsidConfig.class);
                    object3 = object4.getSsid();
                    object10 = (MacFilterAssocConfig)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)map.get("macFilterAssoc")), MacFilterAssocConfig.class);
                    object9 = null;
                    if (object10 != null) {
                        object9 = object10.getRule();
                    }
                    object8 = (SchedulerAssocConfig)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)map.get("schedulerAssoc")), SchedulerAssocConfig.class);
                    object7 = null;
                    if (object8 != null) {
                        object7 = object8.getRule();
                    }
                    object6 = object4.getRadioId();
                    object5 = new ArrayList();
                    object5 = (Integer)object6 == 0 ? com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)map.get("limits_2G")), SsidRateLimit.class) : com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)map.get("limits_5G")), SsidRateLimit.class);
                    if (object3 != null) {
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            String string;
                            Ssid ssid;
                            MacFilterAssocRule macFilterAssocRule2;
                            Object object11;
                            Object object12;
                            SsidC ssidC = (SsidC)iterator.next();
                            if (ssidC.getOperation() != 3) continue;
                            int n2 = ssidC.getId();
                            if (!CollectionUtils.isEmpty((Collection)object5)) {
                                object12 = object5.iterator();
                                while (object12.hasNext()) {
                                    object11 = (SsidRateLimit)object12.next();
                                    if (object11.getId() != n2) continue;
                                    object11.setSsidName(ssidC.getSsidName());
                                }
                            }
                            Object object13 = object12 = (Integer)object6 == 0 ? ap.getWlanGroupId2G() : ap.getWlanGroupId5G();
                            if (object9 != null) {
                                object11 = object9.iterator();
                                while (object11.hasNext()) {
                                    macFilterAssocRule2 = (MacFilterAssocRule)object11.next();
                                    ssid = this.j.getSsidByName(macFilterAssocRule2.getSsid(), (String)object12, (Integer)object6);
                                    if (ssid == null) {
                                        macFilterAssocRule2.setSsid(ssidC.getSsidName());
                                    }
                                    string = this.a(apMac, macFilterAssocRule2.getSsid(), (Integer)object6);
                                    macFilterAssocRule2.setSsid(string);
                                }
                            }
                            if (object7 == null) continue;
                            object11 = object7.iterator();
                            while (object11.hasNext()) {
                                macFilterAssocRule2 = (SchedulerAssocRule)object11.next();
                                ssid = this.j.getSsidByName(macFilterAssocRule2.getSsid(), (String)object12, (Integer)object6);
                                if (ssid == null) {
                                    macFilterAssocRule2.setSsid(ssidC.getSsidName());
                                }
                                string = this.a(apMac, macFilterAssocRule2.getSsid(), (Integer)object6);
                                macFilterAssocRule2.setSsid(string);
                            }
                        }
                        map.put("macFilterAssoc", object10);
                        map.put("schedulerAssoc", object8);
                        if ((Integer)object6 == 0) {
                            map.put("limits_2G", object5);
                        } else {
                            map.put("limits_5G", object5);
                        }
                    }
                }
                if (settingTarget.equals("macFilterList") || settingTarget.equals("macFilterAssoc")) {
                    object4 = (MacFilterAssocConfig)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)map.get("macFilterAssoc")), MacFilterAssocConfig.class);
                    object3 = null;
                    if (object4 != null) {
                        object3 = object4.getRule();
                    }
                    if (object3 != null) {
                        object10 = this.k.getAllWithLazyLoad();
                        object9 = object3.iterator();
                        while (object9.hasNext()) {
                            object8 = (MacFilterAssocRule)object9.next();
                            object7 = object8.getListId();
                            if (object7 != null) {
                                object6 = object10.iterator();
                                while (object6.hasNext()) {
                                    object5 = (StationMacList)object6.next();
                                    if (!object5.getId().equals(object7)) continue;
                                    object8.setListName(object5.getName());
                                }
                            }
                            object6 = this.a(apMac, object8.getSsid(), object8.getBand());
                            object8.setSsid(object6);
                        }
                    }
                    map.put("macFilterAssoc", object4);
                }
                if (settingTarget.equals("schedulerList") || settingTarget.equals("schedulerAssoc")) {
                    object4 = (SchedulerAssocConfig)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)map.get("schedulerAssoc")), SchedulerAssocConfig.class);
                    object3 = null;
                    if (object4 != null) {
                        object3 = object4.getRule();
                    }
                    if (object3 != null) {
                        object10 = this.l.getAllWithLazyLoad();
                        object9 = object3.iterator();
                        while (object9.hasNext()) {
                            object8 = (SchedulerAssocRule)object9.next();
                            object7 = object8.getProfileId();
                            if (object7 != null) {
                                object6 = object10.iterator();
                                while (object6.hasNext()) {
                                    object5 = (Profile)object6.next();
                                    if (!object5.getId().equals(object7)) continue;
                                    object8.setProfileName(object5.getName());
                                }
                            }
                            object6 = this.a(apMac, object8.getSsid(), object8.getBand());
                            object8.setSsid((String)object6);
                        }
                    }
                    map.put("schedulerAssoc", object4);
                    object10 = (SchedulerAssocAp)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)map.get("schedulerAssocAp")), SchedulerAssocAp.class);
                    object9 = null;
                    if (object10 != null) {
                        object9 = object10.getRule();
                    }
                    if (object9 != null) {
                        object8 = object9.iterator();
                        while (object8.hasNext()) {
                            object7 = (SchedulerAssocApRule)object8.next();
                            object6 = object7.getProfileId();
                            if (object6 == null || (object5 = this.l.getById((Integer)object6)) == null) continue;
                            object7.setProfileName(object5.getName());
                        }
                    }
                    map.put("schedulerAssocAp", object10);
                }
                if (macFilterAssocRule == null) {
                    macFilterAssocRule = new SettingRecord(apMac, null, bl ? SettingRecord.SettingStatus.BACKUP : SettingRecord.SettingStatus.PENDING);
                }
                macFilterAssocRule.setContent(com.tp_link.eap.util.a.b.a(map));
            }
            macFilterAssocRule = macFilterAssocRule == null ? new SettingRecord(apMac, com.tp_link.eap.util.a.b.a(map), bl ? SettingRecord.SettingStatus.BACKUP : SettingRecord.SettingStatus.PENDING) : macFilterAssocRule;
            object4 = new EapConfigBody();
            object4 = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)macFilterAssocRule.getContent(), EapConfigBody.class);
            if (settingTarget.equals("portalFreePolicyConfig") && (object3 = object4.getPortalFreePolicyConfig()) != null && object3.getPortalFreePolicy() == null) {
                object3.setPortalFreePolicy(new ArrayList());
            }
            if (bl2) {
                object4.setSequenceId(Integer.valueOf(65536));
            }
            macFilterAssocRule.setContent(com.tp_link.eap.util.a.b.a((Object)object4));
            this.c.save(macFilterAssocRule);
            this.h.refreshVersion(apMac);
        }
    }

    @Override
    public void refreshRecord(String settingTarget, Object settingContent) {
        String string = com.tp_link.eap.d.b.a();
        List<Ap> list = this.e.getSiteAdoptedAps(string);
        this.refreshRecord(settingTarget, settingContent, list);
    }

    @Override
    public void refreshRecord(String settingTarget, Object settingContent, List<Ap> adoptAps) {
        String string = com.tp_link.eap.d.b.a();
        this.p.execute(new a(this, string, adoptAps, settingTarget, settingContent));
    }

    @Override
    public SettingRecord getRecord(String apMac, SettingRecord.SettingStatus status) {
        return this.c.findByApMacAndStatus(apMac, status);
    }

    @Override
    public void setStatus(String recordId, SettingRecord.SettingStatus status) {
        SettingRecord settingRecord = (SettingRecord)this.c.findOne((Serializable)((Object)recordId));
        if (settingRecord != null) {
            settingRecord.setStatus(status);
            this.c.save(settingRecord);
        }
    }

    @Override
    public void initApRecord(Ap configuredAp) {
        if (null == configuredAp) {
            return;
        }
        this.a(configuredAp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Ap ap) {
        Object object2;
        List list;
        com.tp_link.eap.d.b.f((String)ap.getMac());
        String string = ap.getMac();
        EapConfigBody eapConfigBody = this.d.a(string);
        if (eapConfigBody == null) {
            this.a.error("Failed to createGlobalConfigBody for ap {}", (Object)string);
            return;
        }
        eapConfigBody.setTimeSetting(this.d.d());
        eapConfigBody.setLanSetting(com.tp_link.eap.a.a.a((IpSetting)ap.getIpSetting()));
        if (com.tp_link.eap.util.l.a((Ap)ap)) {
            eapConfigBody.setBindVlanConfig(com.tp_link.eap.a.a.a((List)ap.getLanPortSettings()));
        } else if (com.tp_link.eap.util.l.a((DeviceMisc)ap.getDeviceMisc())) {
            eapConfigBody.setBindVlansEntries(com.tp_link.eap.a.a.b((List)ap.getLanPortSettings()));
        }
        if (com.tp_link.eap.util.l.b((DeviceMisc)ap.getDeviceMisc())) {
            eapConfigBody.setLanPortSettings(com.tp_link.eap.a.a.c((List)ap.getLanPortSettings()));
        }
        eapConfigBody.setRogueApGlobal(com.tp_link.eap.a.a.a((boolean)ap.isRogueStatus()));
        eapConfigBody.setWirelessBasic2G(com.tp_link.eap.a.a.a((Radio)ap.getRadio(), (boolean)true));
        eapConfigBody.setWirelessBasic5G(com.tp_link.eap.a.a.a((Radio)ap.getRadio5g(), (boolean)false));
        eapConfigBody.setLoadBalance2G(com.tp_link.eap.a.a.a((LoadBalance)ap.getLoadBalance(), (boolean)true));
        eapConfigBody.setLoadBalance5G(com.tp_link.eap.a.a.a((LoadBalance)ap.getLoadBalance5g(), (boolean)false));
        eapConfigBody.setRogueApSetting(com.tp_link.eap.a.a.d(this.f.getThreadSiteTrustList()));
        eapConfigBody.setClientOperation(com.tp_link.eap.a.a.a(this.m.getSiteBlockClients(com.tp_link.eap.d.b.a()), com.tp_link.eap.monitor.portal.a.a.a(string)));
        eapConfigBody.setAccessControlRules(com.tp_link.eap.a.a.f(this.n.getSiteSubnets()));
        eapConfigBody.setRssi2G(com.tp_link.eap.a.a.a((RssiThreshold)ap.getRssi()));
        eapConfigBody.setRssi5G(com.tp_link.eap.a.a.a((RssiThreshold)ap.getRssi5g()));
        eapConfigBody.setSequenceId(Integer.valueOf(65533));
        SsidConfig ssidConfig = this.d.a(0, ap.getWlanGroupId2G());
        eapConfigBody.setSsid2G(ssidConfig);
        SsidConfig ssidConfig2 = this.d.a(1, ap.getWlanGroupId5G());
        eapConfigBody.setSsid5G(ssidConfig2);
        if (ssidConfig != null) {
            list = ssidConfig.getSsid();
            this.a(list, ap.getSsidOverrides());
        }
        if (ssidConfig2 != null) {
            list = ssidConfig2.getSsid();
            this.a(list, ap.getSsidOverrides5g());
        }
        eapConfigBody.setLimits2G(this.d.b(0, ap.getWlanGroupId2G()));
        eapConfigBody.setLimits5G(this.d.b(1, ap.getWlanGroupId5G()));
        eapConfigBody.setClientRateConfig(this.d.b(ap.getSite()));
        if (ap.getTrunkSetting() != null) {
            eapConfigBody.setTrunkConfig(com.tp_link.eap.a.a.a((TrunkSetting)ap.getTrunkSetting()));
        }
        eapConfigBody.setRegion(ap.getDeviceMisc().getCustomizeRegion());
        if (com.tp_link.eap.util.l.c((DeviceMisc)ap.getDeviceMisc())) {
            eapConfigBody.setMesh(this.d.a(eapConfigBody.getMesh(), ap.getMac()));
        }
        if (com.tp_link.eap.util.restore.a.c((String)string) == 1) {
            eapConfigBody.setSequenceId(Integer.valueOf(65536));
            com.tp_link.eap.util.restore.a.b((String)string);
        }
        list = new Query();
        new Criteria();
        Criteria criteria = Criteria.where((String)"apMac").is((Object)string).and("status").ne((Object)SettingRecord.SettingStatus.SENDING);
        list.addCriteria(criteria);
        List list2 = this.o.find((Query)list, SettingRecord.class);
        if (!CollectionUtils.isEmpty((Collection)list2)) {
            this.a.info("delete old invalid records for {}", (Object)string);
            for (Object object2 : list2) {
                this.c.delete(object2);
            }
        }
        SettingRecord settingRecord = new SettingRecord();
        settingRecord.setApMac(string);
        settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
        settingRecord.setStatus(SettingRecord.SettingStatus.PENDING);
        this.c.save(settingRecord);
        Object object3 = object2 = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object3) {
            this.a.debug("change record status to true for mac : " + string);
            com.tp_link.eap.monitor.record.a.a.b(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initRecordForSameVersion(Ap configuredAp) {
        Object object;
        MeshSetting meshSetting;
        if (null == configuredAp) {
            return;
        }
        com.tp_link.eap.d.b.f((String)configuredAp.getMac());
        String string = com.tp_link.eap.d.b.a();
        String string2 = configuredAp.getMac();
        EapConfigBody eapConfigBody = new EapConfigBody();
        eapConfigBody.setSequenceId(Integer.valueOf(65533));
        eapConfigBody.setTimeSetting(this.d.d());
        if (com.tp_link.eap.util.l.c((DeviceMisc)configuredAp.getDeviceMisc())) {
            meshSetting = this.i.getMeshSetting();
            if (meshSetting != null) {
                eapConfigBody.setMesh(this.d.a(meshSetting));
            } else {
                this.a.error("Missing meshSetting of site {}.", (Object)string);
            }
            eapConfigBody.setMesh(this.d.a(eapConfigBody.getMesh(), configuredAp.getMac()));
        }
        meshSetting = new SettingRecord();
        meshSetting.setApMac(string2);
        meshSetting.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
        meshSetting.setStatus(SettingRecord.SettingStatus.PENDING);
        this.c.save(meshSetting);
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string2);
        synchronized (object2) {
            this.a.debug("change record status to true for mac : " + string2);
            com.tp_link.eap.monitor.record.a.a.b(string2);
        }
    }

    private void a(List<SsidC> list, List<SsidOverride> list2) {
        if (list != null && list2 != null) {
            assert (list.size() == list2.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                int n2;
                SsidC ssidC = list.get(i2);
                SsidOverride ssidOverride = null;
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (list2.get(n2).getIndex() != ssidC.getId().intValue()) continue;
                    ssidOverride = list2.remove(n2);
                }
                if (ssidOverride == null) {
                    this.a.warn("Unexpected null ponit occured while build override info for ssid.");
                    return;
                }
                if (!ssidOverride.isEnable()) continue;
                ssidC.setSsidName(ssidOverride.getSsid());
                if (ssidOverride.isVlanEnable() && ssidOverride.getVlanId() != null) {
                    ssidC.setVlanId(ssidOverride.getVlanId());
                }
                if (!com.tp_link.eap.util.a.e.a((String)ssidOverride.getPsk())) {
                    n2 = ssidC.getSecurityMode();
                    if (n2 != 3) continue;
                    ssidC.setPskKey(ssidOverride.getPsk());
                    continue;
                }
                if (ssidC.getSecurityMode() != 3) continue;
                ssidC.setSecurityMode(Integer.valueOf(0));
            }
        }
    }

    private Map<String, Object> a(String string, SettingRecord settingRecord, String string2, Object object) {
        String string3 = this.a(string2, object);
        Map<String, Object> map = new HashMap();
        if (settingRecord == null) {
            if (string2.equals("ssid_2G") || string2.equals("ssid_5G")) {
                SsidConfig ssidConfig = (SsidConfig)object;
                boolean bl = string2.equals("ssid_2G");
                map.put(string2, this.a(string, ssidConfig, bl));
            } else {
                map.put(string2, object);
            }
        } else {
            map = com.tp_link.eap.util.a.b.a((String)settingRecord.getContent());
            if (map == null) {
                map = new HashMap();
                map.put(string2, object);
            } else {
                if (string2.equals("mesh")) {
                    Mesh mesh = (Mesh)object;
                    Mesh mesh2 = null;
                    if (map.get(string2) != null) {
                        mesh2 = (Mesh)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)map.get(string2)), Mesh.class);
                    }
                    Mesh mesh3 = this.a(mesh, mesh2);
                    map.put(string2, mesh3);
                    return map;
                }
                Object v = map.get(string2);
                if (v == null) {
                    if (string2.equals("ssid_2G") || string2.equals("ssid_5G")) {
                        SsidConfig ssidConfig = (SsidConfig)object;
                        boolean bl = string2.equals("ssid_2G");
                        map.put(string2, this.a(string, ssidConfig, bl));
                    } else {
                        map.put(string2, object);
                    }
                } else {
                    HashMap hashMap = (HashMap)v;
                    if (hashMap.get(string3) == null) {
                        if (string2.equals("roaming")) {
                            hashMap.put(string3, ((IssuedRoamingInfo)object).getApNeighborLists());
                            return map;
                        }
                        hashMap.put(string3, JSONObject.fromObject((Object)com.tp_link.eap.util.a.b.a((Object)object)).get(string3));
                        map.put(string2, hashMap);
                    } else {
                        Object object2 = this.a(hashMap.get(string3), object, string2, settingRecord.getApMac());
                        if (object2 == null) {
                            map.remove(string2);
                        } else {
                            hashMap.put(string3, object2);
                            map.put(string2, hashMap);
                        }
                    }
                }
            }
        }
        return map;
    }

    private Object a(Object object, Object object2, String string, String string2) {
        switch (string) {
            case "ssid_2G": 
            case "ssid_5G": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), SsidC.class);
                object = this.a(list, (SsidConfig)object2, string2, string == "ssid_2G");
                break;
            }
            case "portalFreePolicyConfig": {
                List<Object> list = null;
                if (object2 != null) {
                    PortalFreePolicyConfig portalFreePolicyConfig = (PortalFreePolicyConfig)object2;
                    list = portalFreePolicyConfig.getURLPortalFreePolicy() != null && portalFreePolicyConfig.getURLPortalFreePolicy().size() > 0 ? com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), URLPortalFreePolicy.class) : com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), PortalFreePolicy.class);
                } else {
                    list = new ArrayList<CommonCloneable>();
                    this.a.error("portalFreePolicyConfig's settingObj is null.");
                }
                object = this.a(list, (PortalFreePolicyConfig)object2);
                break;
            }
            case "macFilterList": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), MacFilterRule.class);
                object = this.a(list, (MacFilterConfig)object2);
                break;
            }
            case "macFilterAssoc": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), MacFilterAssocRule.class);
                object = this.a(list, (MacFilterAssocConfig)object2);
                break;
            }
            case "schedulerList": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), SchedulerRule.class);
                object = this.a(list, (SchedulerConfig)object2);
                break;
            }
            case "schedulerAssoc": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), SchedulerAssocRule.class);
                object = this.a(list, (SchedulerAssocConfig)object2);
                break;
            }
            case "schedulerAssocAp": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), SchedulerAssocApRule.class);
                object = this.a(list, (SchedulerAssocAp)object2);
                break;
            }
            case "roaming": {
                List list = com.tp_link.eap.util.a.b.b((String)com.tp_link.eap.util.a.b.a((Object)object), ApNeighborList.class);
                object = this.a(list, (IssuedRoamingInfo)object2);
                break;
            }
            default: {
                this.a.debug("unknown setting target while merge setting record: " + string);
            }
        }
        return object;
    }

    private Object a(List<SsidC> list, SsidConfig ssidConfig, String string, boolean bl) {
        boolean bl2 = false;
        if (!list.isEmpty()) {
            assert (ssidConfig.getSsid().size() == 1);
            SsidC ssidC = (SsidC)((SsidC)ssidConfig.getSsid().get(0)).clone();
            if (ssidC.getOperation().equals(3) && (ssidC.getOverride() == null || !ssidC.getOverride().booleanValue())) {
                Ap ap = this.e.getApDetail(string);
                List list2 = bl ? ap.getSsidOverrides() : ap.getSsidOverrides5g();
                if (list2 != null && !list2.isEmpty()) {
                    for (SsidOverride ssidOverride : list2) {
                        if (ssidOverride.getIndex() != ssidC.getId().intValue() || !ssidOverride.isEnable()) continue;
                        ssidC.setSsidName(ssidOverride.getSsid());
                        ssidC.setOldSsidName(ssidOverride.getSsid());
                        if (ssidOverride.isVlanEnable() && ssidOverride.getVlanId() != null) {
                            ssidC.setVlanId(ssidOverride.getVlanId());
                        }
                        if (!com.tp_link.eap.util.a.e.a((String)ssidOverride.getPsk())) {
                            int n2 = ssidC.getSecurityMode();
                            if (n2 != 3) continue;
                            ssidC.setPskKey(ssidOverride.getPsk());
                            continue;
                        }
                        if (ssidC.getSecurityMode() != 3) continue;
                        ssidC.setSecurityMode(Integer.valueOf(0));
                    }
                }
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!list.get(i2).getId().equals(ssidC.getId())) continue;
                if (ssidC.getOperation() == 2) {
                    list.remove(i2);
                    break;
                }
                if (ssidC.getOperation() != 3) continue;
                if (list.get(i2).getOperation() == 1) {
                    ssidC.setOperation(Integer.valueOf(1));
                    ssidC.setOldSsidName(null);
                } else if (list.get(i2).getOperation() == 3) {
                    ssidC.setOldSsidName(list.get(i2).getOldSsidName());
                    ssidC.setOverride(null);
                }
                list.set(i2, ssidC);
                bl2 = true;
                break;
            }
            if (!bl2) {
                list.add(ssidC);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private Object a(List<CommonCloneable> list, PortalFreePolicyConfig portalFreePolicyConfig) {
        boolean bl = false;
        if (list.isEmpty() && portalFreePolicyConfig.getPortalFreePolicy() != null && portalFreePolicyConfig.getPortalFreePolicy().size() > 0) {
            return portalFreePolicyConfig.getPortalFreePolicy();
        }
        if (!list.isEmpty()) {
            if (portalFreePolicyConfig.getURLPortalFreePolicy() != null && portalFreePolicyConfig.getURLPortalFreePolicy().size() > 0) {
                assert (portalFreePolicyConfig.getURLPortalFreePolicy().size() == 1);
                URLPortalFreePolicy uRLPortalFreePolicy = (URLPortalFreePolicy)((URLPortalFreePolicy)portalFreePolicyConfig.getURLPortalFreePolicy().get(0)).clone();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    URLPortalFreePolicy uRLPortalFreePolicy2 = (URLPortalFreePolicy)list.get(i2);
                    if (uRLPortalFreePolicy2.getId().intValue() != uRLPortalFreePolicy.getId().intValue()) continue;
                    if (uRLPortalFreePolicy.getOperation() == 2) {
                        if (uRLPortalFreePolicy2.getOperation() == 1) {
                            bl = true;
                        } else {
                            uRLPortalFreePolicy.setName(uRLPortalFreePolicy2.getOldName());
                        }
                        list.remove(i2);
                        break;
                    }
                    if (uRLPortalFreePolicy2.getOperation() == 3) {
                        uRLPortalFreePolicy.setOldName(uRLPortalFreePolicy2.getOldName());
                        list.remove(i2--);
                    }
                    if (uRLPortalFreePolicy2.getOperation() != 1) continue;
                    bl = true;
                    uRLPortalFreePolicy2.setName(uRLPortalFreePolicy.getName());
                    uRLPortalFreePolicy2.setEnable(uRLPortalFreePolicy.getEnable());
                    uRLPortalFreePolicy2.setUrl(uRLPortalFreePolicy.getUrl());
                    uRLPortalFreePolicy2.setType(uRLPortalFreePolicy.getType());
                    break;
                }
                if (!bl) {
                    list.add((CommonCloneable)uRLPortalFreePolicy);
                }
            } else {
                assert (portalFreePolicyConfig.getPortalFreePolicy().size() == 1);
                PortalFreePolicy portalFreePolicy = (PortalFreePolicy)((PortalFreePolicy)portalFreePolicyConfig.getPortalFreePolicy().get(0)).clone();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    PortalFreePolicy portalFreePolicy2 = (PortalFreePolicy)list.get(i3);
                    if (portalFreePolicy2.getId().intValue() != portalFreePolicy.getId().intValue()) continue;
                    if (portalFreePolicy.getOperation() == 2) {
                        if (portalFreePolicy2.getOperation() == 1) {
                            bl = true;
                        } else {
                            portalFreePolicy.setName(portalFreePolicy2.getOldName());
                        }
                        list.remove(i3);
                        break;
                    }
                    if (portalFreePolicy2.getOperation() == 3) {
                        portalFreePolicy.setOldName(portalFreePolicy2.getOldName());
                        list.remove(i3--);
                    }
                    if (portalFreePolicy2.getOperation() != 1) continue;
                    bl = true;
                    portalFreePolicy2.setName(portalFreePolicy.getName());
                    portalFreePolicy2.setDstIp(portalFreePolicy.getDstIp());
                    portalFreePolicy2.setDstMask(portalFreePolicy.getDstMask());
                    portalFreePolicy2.setDstPort(portalFreePolicy.getDstPort());
                    portalFreePolicy2.setEnable(portalFreePolicy.getEnable());
                    portalFreePolicy2.setSrcIp(portalFreePolicy.getSrcIp());
                    portalFreePolicy2.setSrcMac(portalFreePolicy.getSrcMac());
                    portalFreePolicy2.setSrcMask(portalFreePolicy.getSrcMask());
                    portalFreePolicy2.setType(portalFreePolicy.getType());
                    break;
                }
                if (!bl) {
                    list.add((CommonCloneable)portalFreePolicy);
                }
            }
        }
        return list;
    }

    private Object a(List<MacFilterRule> list, MacFilterConfig macFilterConfig) {
        boolean bl = false;
        if (!list.isEmpty()) {
            assert (macFilterConfig.getRule().size() == 1);
            MacFilterRule macFilterRule = (MacFilterRule)((MacFilterRule)macFilterConfig.getRule().get(0)).clone();
            if (macFilterRule.getRuleId() == null) {
                MacFilterRule macFilterRule2;
                int n2;
                if (macFilterRule.getOperation() == 2) {
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        macFilterRule2 = list.get(n2);
                        if (macFilterRule2.getListId().intValue() != macFilterRule.getListId().intValue()) continue;
                        if (macFilterRule2.getRuleId() == null) {
                            if (macFilterRule2.getOperation() == 1) {
                                bl = true;
                            } else {
                                com.tp_link.eap.monitor.globalsetting.a.b.a(com.tp_link.eap.monitor.globalsetting.a.c.a, macFilterRule, macFilterRule2);
                            }
                        }
                        list.remove(n2--);
                    }
                }
                if (macFilterRule.getOperation() == 3) {
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        macFilterRule2 = list.get(n2);
                        if (macFilterRule2.getListId().intValue() != macFilterRule.getListId().intValue()) continue;
                        if (macFilterRule2.getRuleId() == null) {
                            if (macFilterRule2.getOperation() == 3) {
                                list.remove(n2--);
                                com.tp_link.eap.monitor.globalsetting.a.b.b(com.tp_link.eap.monitor.globalsetting.a.c.a, macFilterRule, macFilterRule2);
                            }
                            if (macFilterRule2.getOperation() != 1) continue;
                            bl = true;
                            macFilterRule2.setListName(macFilterRule.getListName());
                            list.set(n2, macFilterRule2);
                            continue;
                        }
                        macFilterRule2.setListName(macFilterRule.getListName());
                        list.set(n2, macFilterRule2);
                    }
                }
            } else {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    MacFilterRule macFilterRule3 = list.get(i2);
                    if (macFilterRule3.getListId().intValue() != macFilterRule.getListId().intValue() || macFilterRule3.getRuleId() == null || macFilterRule3.getRuleId().intValue() != macFilterRule.getRuleId().intValue()) continue;
                    if (macFilterRule.getOperation() == 2) {
                        if (macFilterRule3.getOperation() == 1) {
                            bl = true;
                        } else {
                            com.tp_link.eap.monitor.globalsetting.a.b.a(com.tp_link.eap.monitor.globalsetting.a.c.b, macFilterRule, macFilterRule3);
                        }
                        list.remove(i2);
                    } else {
                        if (macFilterRule.getOperation() != 3) continue;
                        if (macFilterRule3.getOperation() == 1) {
                            macFilterRule.setOperation(Integer.valueOf(1));
                            macFilterRule.setOldListName(null);
                            macFilterRule.setOldMac(null);
                        } else {
                            this.a.debug("mac address merge: edit to edit: " + macFilterRule.toString());
                            com.tp_link.eap.monitor.globalsetting.a.b.b(com.tp_link.eap.monitor.globalsetting.a.c.b, macFilterRule, macFilterRule3);
                            this.a.debug("After convert :" + macFilterRule.toString());
                        }
                        list.set(i2, macFilterRule);
                        bl = true;
                    }
                    break;
                }
            }
            if (!bl) {
                if (macFilterRule.getRuleId() == null) {
                    list.add(this.a(list), macFilterRule);
                } else {
                    list.add(macFilterRule);
                }
            }
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    private Integer a(List<MacFilterRule> list) {
        assert (list != null);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).getRuleId() == null) continue;
            return i2;
        }
        return list.size();
    }

    private Object a(List<SchedulerRule> list, SchedulerConfig schedulerConfig) {
        boolean bl = false;
        if (!list.isEmpty()) {
            assert (schedulerConfig.getRule().size() == 1);
            SchedulerRule schedulerRule = (SchedulerRule)((SchedulerRule)schedulerConfig.getRule().get(0)).clone();
            if (schedulerRule.getRuleId() == null) {
                SchedulerRule schedulerRule2;
                int n2;
                if (schedulerRule.getOperation() == 2) {
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        schedulerRule2 = list.get(n2);
                        if (schedulerRule2.getProfileId().intValue() != schedulerRule.getProfileId().intValue()) continue;
                        if (schedulerRule2.getRuleId() == null) {
                            if (schedulerRule2.getOperation() == 1) {
                                bl = true;
                            } else {
                                com.tp_link.eap.monitor.globalsetting.a.b.a(com.tp_link.eap.monitor.globalsetting.a.c.c, schedulerRule, schedulerRule2);
                            }
                        }
                        list.remove(n2--);
                    }
                }
                if (schedulerRule.getOperation() == 3) {
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        schedulerRule2 = list.get(n2);
                        if (schedulerRule2.getProfileId().intValue() != schedulerRule.getProfileId().intValue()) continue;
                        if (schedulerRule2.getRuleId() == null) {
                            if (schedulerRule2.getOperation() == 3) {
                                list.remove(n2--);
                                com.tp_link.eap.monitor.globalsetting.a.b.b(com.tp_link.eap.monitor.globalsetting.a.c.c, schedulerRule, schedulerRule2);
                            }
                            if (schedulerRule2.getOperation() != 1) continue;
                            bl = true;
                            schedulerRule2.setProfileName(schedulerRule.getProfileName());
                            list.remove(n2);
                            int n3 = this.b(list);
                            list.add(n3, schedulerRule2);
                            n2 = n3 < n2 ? n3 + 1 : n2;
                            continue;
                        }
                        schedulerRule2.setProfileName(schedulerRule.getProfileName());
                        list.set(n2, schedulerRule2);
                    }
                }
            } else {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    SchedulerRule schedulerRule3 = list.get(i2);
                    if (schedulerRule3.getProfileId().intValue() != schedulerRule.getProfileId().intValue() || schedulerRule3.getRuleId() == null || schedulerRule3.getRuleId().intValue() != schedulerRule.getRuleId().intValue()) continue;
                    if (schedulerRule.getOperation() == 2) {
                        if (schedulerRule3.getOperation() == 1) {
                            bl = true;
                        } else {
                            com.tp_link.eap.monitor.globalsetting.a.b.a(com.tp_link.eap.monitor.globalsetting.a.c.d, schedulerRule, schedulerRule3);
                        }
                        list.remove(i2);
                    } else {
                        if (schedulerRule.getOperation() != 3) continue;
                        if (schedulerRule3.getOperation() == 1) {
                            schedulerRule.setOperation(Integer.valueOf(1));
                        } else {
                            com.tp_link.eap.monitor.globalsetting.a.b.b(com.tp_link.eap.monitor.globalsetting.a.c.d, schedulerRule, schedulerRule3);
                        }
                        list.set(i2, schedulerRule);
                        bl = true;
                    }
                    break;
                }
            }
            if (!bl) {
                if (schedulerRule.getRuleId() == null) {
                    list.add(this.b(list), schedulerRule);
                } else {
                    list.add(schedulerRule);
                }
            }
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    private Integer b(List<SchedulerRule> list) {
        assert (list != null);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).getRuleId() == null) continue;
            return i2;
        }
        return list.size();
    }

    private Object a(List<SchedulerAssocApRule> list, SchedulerAssocAp schedulerAssocAp) {
        boolean bl = false;
        if (!list.isEmpty()) {
            assert (schedulerAssocAp.getRule().size() == 1);
            SchedulerAssocApRule schedulerAssocApRule = (SchedulerAssocApRule)schedulerAssocAp.getRule().get(0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!list.get(i2).getMac().equals(schedulerAssocApRule.getMac())) continue;
                list.set(i2, schedulerAssocApRule);
                bl = true;
                break;
            }
            if (!bl) {
                list.add(schedulerAssocApRule);
            }
        }
        return list;
    }

    private Object a(List<SchedulerAssocRule> list, SchedulerAssocConfig schedulerAssocConfig) {
        boolean bl = false;
        if (!list.isEmpty()) {
            assert (schedulerAssocConfig.getRule().size() == 1);
            SchedulerAssocRule schedulerAssocRule = (SchedulerAssocRule)schedulerAssocConfig.getRule().get(0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                SchedulerAssocRule schedulerAssocRule2 = list.get(i2);
                if (!list.get(i2).getSsid().equals(schedulerAssocRule.getSsid()) || !schedulerAssocRule2.getBand().equals(schedulerAssocRule.getBand())) continue;
                list.set(i2, schedulerAssocRule);
                bl = true;
                break;
            }
            if (!bl) {
                list.add(schedulerAssocRule);
            }
        }
        return list;
    }

    private Object a(List<MacFilterAssocRule> list, MacFilterAssocConfig macFilterAssocConfig) {
        boolean bl = false;
        if (!list.isEmpty()) {
            assert (macFilterAssocConfig.getRule().size() == 1);
            MacFilterAssocRule macFilterAssocRule = (MacFilterAssocRule)macFilterAssocConfig.getRule().get(0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                MacFilterAssocRule macFilterAssocRule2 = list.get(i2);
                if (!macFilterAssocRule2.getSsid().equals(macFilterAssocRule.getSsid()) || !macFilterAssocRule2.getBand().equals(macFilterAssocRule.getBand())) continue;
                list.set(i2, macFilterAssocRule);
                bl = true;
                break;
            }
            if (!bl) {
                list.add(macFilterAssocRule);
            }
        }
        return list;
    }

    private Object a(List<ApNeighborList> list, IssuedRoamingInfo issuedRoamingInfo) {
        boolean bl = false;
        if (!list.isEmpty() && null != issuedRoamingInfo.getApNeighborLists() && 1 == issuedRoamingInfo.getApNeighborLists().size()) {
            ApNeighborList apNeighborList = (ApNeighborList)issuedRoamingInfo.getApNeighborLists().get(0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ApNeighborList apNeighborList2 = list.get(i2);
                if (!apNeighborList2.getBssid().equals(apNeighborList.getBssid())) continue;
                list.set(i2, apNeighborList);
                bl = true;
                break;
            }
            if (!bl) {
                list.add(apNeighborList);
            }
        }
        return list;
    }

    private boolean a(String string) {
        return string.equals("ssid_2G") || string.equals("ssid_5G") || string.equals("portalFreePolicyConfig") || string.equals("macFilterList") || string.equals("schedulerList") || string.equals("schedulerAssocAp") || string.equals("macFilterAssoc") || string.equals("schedulerAssoc") || string.equals("clientConfig") || string.equals("rogueApSetting") || string.equals("roaming") || string.equals("mesh");
    }

    private String a(String string, Object object) {
        String string2 = null;
        switch (string) {
            case "ssid_2G": 
            case "ssid_5G": {
                string2 = "ssid";
                break;
            }
            case "portalFreePolicyConfig": {
                PortalFreePolicyConfig portalFreePolicyConfig;
                string2 = "portalFreePolicy";
                if (object == null || (portalFreePolicyConfig = (PortalFreePolicyConfig)object).getURLPortalFreePolicy() == null || portalFreePolicyConfig.getURLPortalFreePolicy().size() <= 0) break;
                string2 = "urlPortalFreePolicy";
                break;
            }
            case "macFilterList": 
            case "schedulerList": 
            case "schedulerAssocAp": 
            case "schedulerAssoc": 
            case "macFilterAssoc": {
                string2 = "rule";
                break;
            }
            case "clientConfig": 
            case "rogueApSetting": 
            case "mesh": {
                break;
            }
            case "roaming": {
                string2 = "neighborList";
                break;
            }
            default: {
                this.a.warn("failed to get setting child for setting target : " + string);
            }
        }
        return string2;
    }

    private SsidConfig a(String string, SsidConfig ssidConfig, boolean bl) {
        SsidConfig ssidConfig2 = new SsidConfig();
        ssidConfig2.setRadioId(ssidConfig.getRadioId());
        assert (ssidConfig.getSsid().size() == 1);
        SsidC ssidC = (SsidC)((SsidC)ssidConfig.getSsid().get(0)).clone();
        if (ssidC.getOperation().equals(3)) {
            if (ssidC.getOverride() != null && ssidC.getOverride().booleanValue()) {
                ssidC.setOverride(null);
                ssidConfig2.setSsid(Collections.singletonList(ssidC));
                return ssidConfig2;
            }
            Ap ap = this.e.getApDetail(string);
            List list = bl ? ap.getSsidOverrides() : ap.getSsidOverrides5g();
            if (list != null && !list.isEmpty()) {
                for (SsidOverride ssidOverride : list) {
                    if (ssidOverride.getIndex() != ssidC.getId().intValue() || !ssidOverride.isEnable()) continue;
                    ssidC.setSsidName(ssidOverride.getSsid());
                    ssidC.setOldSsidName(ssidOverride.getSsid());
                    if (ssidOverride.isVlanEnable() && ssidOverride.getVlanId() != null) {
                        ssidC.setVlanId(ssidOverride.getVlanId());
                    }
                    if (!com.tp_link.eap.util.a.e.a((String)ssidOverride.getPsk())) {
                        int n2 = ssidC.getSecurityMode();
                        if (n2 != 3) continue;
                        ssidC.setPskKey(ssidOverride.getPsk());
                        continue;
                    }
                    if (ssidC.getSecurityMode() != 3) continue;
                    ssidC.setSecurityMode(Integer.valueOf(0));
                }
            }
        }
        ssidConfig2.setSsid(Collections.singletonList(ssidC));
        return ssidConfig2;
    }

    private String a(String string, String string2, int n2) {
        List list;
        Ap ap = this.e.getApDetail(string);
        if (ap == null) {
            return string2;
        }
        List list2 = list = n2 == 0 ? ap.getSsidOverrides() : ap.getSsidOverrides5g();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return string2;
        }
        for (SsidOverride ssidOverride : list) {
            if (!ssidOverride.isEnable() || !ssidOverride.getGlobalSsid().equals(string2)) continue;
            return ssidOverride.getSsid();
        }
        return string2;
    }

    private IssuedRoamingInfo a(Object object, Object object2) {
        IssuedRoamingInfo issuedRoamingInfo;
        IssuedRoamingInfo issuedRoamingInfo2 = (IssuedRoamingInfo)com.tp_link.eap.util.a.b.a((String)com.tp_link.eap.util.a.b.a((Object)object), IssuedRoamingInfo.class);
        if (null == issuedRoamingInfo2) {
            issuedRoamingInfo2 = new IssuedRoamingInfo();
        }
        if (null != (issuedRoamingInfo = (IssuedRoamingInfo)object2).getFastRoaming()) {
            issuedRoamingInfo2.setFastRoaming(issuedRoamingInfo.getFastRoaming());
        }
        if (null != issuedRoamingInfo.getDualBand11kReport()) {
            issuedRoamingInfo2.setDualBand11kReport(issuedRoamingInfo.getDualBand11kReport());
        }
        if (null != issuedRoamingInfo.getForceDisassociation()) {
            issuedRoamingInfo2.setForceDisassociation(issuedRoamingInfo.getForceDisassociation());
        }
        if (null != issuedRoamingInfo.getRequestNeighbor()) {
            issuedRoamingInfo2.setRequestNeighbor(issuedRoamingInfo.getRequestNeighbor());
        }
        return issuedRoamingInfo2;
    }

    private Mesh a(Mesh mesh, Mesh mesh2) {
        if (mesh2 == null) {
            return mesh;
        }
        Mesh mesh3 = mesh;
        if (mesh.getIsNewConfig() == 1) {
            mesh3 = mesh;
        } else {
            List list;
            mesh3.setIsNewConfig(mesh2.getIsNewConfig());
            if (mesh.getConfigMesh() == null) {
                mesh3.setConfigMesh(mesh2.getConfigMesh());
            }
            if (mesh.getConfigTargetIP() == null) {
                mesh3.setConfigTargetIP(mesh2.getConfigTargetIP());
            }
            if (CollectionUtils.isEmpty((Collection)mesh.getConfigChildAPList())) {
                mesh3.setConfigChildAPList(mesh2.getConfigChildAPList());
            }
            if (!CollectionUtils.isEmpty((Collection)(list = mesh.getConfigChildAPList()))) {
                HashSet<String> hashSet = new HashSet<String>();
                int n2 = 0;
                for (Object object : list) {
                    hashSet.add(object.getMac());
                    if (object.getAction() != 1) continue;
                    ++n2;
                }
                List list2 = mesh2.getConfigChildAPList();
                if (!CollectionUtils.isEmpty((Collection)list2)) {
                    Object object;
                    object = list2.iterator();
                    while (object.hasNext()) {
                        ConfigChildAP configChildAP = (ConfigChildAP)object.next();
                        if (hashSet.contains(configChildAP.getMac())) continue;
                        if (configChildAP.getAction() == 1) {
                            if (n2 >= 4) continue;
                            list.add(configChildAP);
                            ++n2;
                            continue;
                        }
                        list.add(configChildAP);
                    }
                }
                mesh3.setConfigChildAPList(list);
            }
        }
        return mesh3;
    }

    private boolean b(String string, Object object) {
        IssuedRoamingInfo issuedRoamingInfo;
        boolean bl = true;
        if (string.equals("roaming") && (issuedRoamingInfo = (IssuedRoamingInfo)object).getFastRoaming() == null && issuedRoamingInfo.getDualBand11kReport() == null && issuedRoamingInfo.getForceDisassociation() == null) {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ b a(RecordService recordService) {
        return recordService.h;
    }
}

